shape = {}

function shape.Calculate()
   local hw = shape.width / 2
   local hh = shape.height / 2
   local r = shape.filletRad
   Line(-hw, -hh + r, -hw, hh - r)
   ArcA(-hw, hh - r, -hw + r, hh - r, math.pi/2)
   Line(-hw + r, hh, hw - r, hh)
   ArcA(hw - r, hh, hw - r, hh - r, math.pi/2)
   Line(hw, hh - r, hw, -hh + r)
   ArcA(hw, -hh + r, hw - r, -hh + r, math.pi/2)
   Line(hw - r, -hh, -hw + r, -hh)
   ArcA(-hw + r, -hh, -hw + r, -hh + r, math.pi/2)
   hw = shape.holeHoriz / 2
   hh = shape.holeVert / 2

   Circle(-hw, -hh, shape.holeDia)
   Circle( hw, -hh, shape.holeDia)
   Circle(-hw,  hh, shape.holeDia)
   Circle( hw,  hh, shape.holeDia)
end

AddNumControl("width", "Width", sc.unitLINEAR, 100, 0.1, 10000, "width.png")
AddNumControl("height", "Height", sc.unitLINEAR, 100, 0.1, 10000, "height.png")
AddNumControl("holeHoriz", "Horizontal hole spacing", sc.unitLINEAR, 80, 0.1, 10000, "hHole.png")
AddNumControl("holeVert", "Vertical hole spacing", sc.unitLINEAR, 80, 0.1, 10000, "vHole.png")
AddNumControl("holeDia", "Hole diameter", sc.unitLINEAR, 10, 0.1, 10000, "holeDia.png")
AddNumControl("filletRad", "Fillet radius", sc.unitLINEAR, 10, 0.1, 10000, "fillet.png")
